// MSVC ViewerView.cpp : implementation of the CMSVCViewerView class
//

#include "stdafx.h"
#include "MSVC Viewer.h"

#include "MSVC ViewerDoc.h"
#include "MSVC ViewerView.h"
#include "inputdialog.h"
#include <afxctl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerView

IMPLEMENT_DYNCREATE(CMSVCViewerView, CView)

BEGIN_MESSAGE_MAP(CMSVCViewerView, CView)
	//{{AFX_MSG_MAP(CMSVCViewerView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_FLIPH, OnFliph)
	ON_COMMAND(ID_FLIPV, OnFlipv)
	ON_COMMAND(ID_LEVELDOWN, OnLeveldown)
	ON_COMMAND(ID_LEVELUP, OnLevelup)
	ON_COMMAND(ID_ROTATE, OnRotate)
	ON_COMMAND(ID_WINDOWWIDE, OnWindowwide)
	ON_COMMAND(ID_WINDOWNARROW, OnWindownarrow)
	ON_WM_DESTROY()
	ON_COMMAND(ID_ZOOMIN, OnZoomin)
	ON_UPDATE_COMMAND_UI(ID_ZOOMIN, OnUpdateZoomin)
	ON_COMMAND(ID_ZOOMOUT, OnZoomout)
	ON_UPDATE_COMMAND_UI(ID_ZOOMOUT, OnUpdateZoomout)
	ON_COMMAND(ID_STRETCHTOFIT, OnStretchtofit)
	ON_UPDATE_COMMAND_UI(ID_STRETCHTOFIT, OnUpdateStretchtofit)
	ON_COMMAND(ID_FILE_APPLYPRESENTATIONSTATE, OnFileApplypresentationstate)
	ON_COMMAND(ID_FILE_EXPORT, OnFileExport)
	ON_COMMAND(ID_REMOTE_SENDSELECTED, OnRemoteSendselected)
	ON_COMMAND(ID_CINE_RUNCINE, OnCineRuncine)
	ON_COMMAND(ID_CINE_REVERSE, OnCineReverse)
	ON_COMMAND(ID_CINE_OSCILLATE, OnCineOscillate)
	ON_COMMAND(ID_CINE_STOP, OnCineStop)
	ON_COMMAND(ID_FILE_PRINTDICOM, OnFilePrintdicom)
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerView construction/destruction

CMSVCViewerView::CMSVCViewerView()
{
	pOptions=&(((CMSVCViewerApp*)AfxGetApp())->options);
}

CMSVCViewerView::~CMSVCViewerView()
{
}

BOOL CMSVCViewerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerView drawing

void CMSVCViewerView::OnDraw(CDC* pDC)
{
	CMSVCViewerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerView diagnostics

#ifdef _DEBUG
void CMSVCViewerView::AssertValid() const
{
	CView::AssertValid();
}

void CMSVCViewerView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMSVCViewerDoc* CMSVCViewerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMSVCViewerDoc)));
	return (CMSVCViewerDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMSVCViewerView message handlers

int CMSVCViewerView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;

	m_viewer.Create(NULL, WS_VISIBLE, 
	   CRect(0,0,lpCreateStruct->cx,lpCreateStruct->cy), 
	   this, 0);
	m_viewer.SetBackColour(RGB(0,0,64));

	pSink=new CDicomViewerSink(&m_viewer,this);
	
	AfxConnectionAdvise(m_viewer.GetControlUnknown(),IID_IDicomViewerSink,pSink->GetIDispatch(true),false,&SinkCookie);


	
	return 0;
}

void CMSVCViewerView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	m_viewer.SetWindowPos(this,0,0,cx,cy,SWP_NOZORDER);	
}

BOOL CMSVCViewerView::OnEraseBkgnd(CDC* pDC) 
{
	return -1;  // erasing not required, as Viewer fill control.	
}

void CMSVCViewerView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	IDicomImagesPtr images=m_viewer.GetImages();
	CMSVCViewerDoc * document = GetDocument();
	ActiveImage=document->Image;
	if(document && bool(ActiveImage))
	{
		if(images->Count==0)
			images->Add(document->Image);

		ActiveImage=m_viewer.GetCurrentImage();
		ActiveImage->Release();


		document->SetTitle(ActiveImage->Name);
	}
	images->Release();
}

void CMSVCViewerView::OnEditCopy() 
{
	ActiveImage->Copy();
}

void CMSVCViewerView::OnFliph() 
{
	int fs=ActiveImage->FlipState;
	fs^= 1;
	ActiveImage->FlipState=(doFlipState)fs;
}

void CMSVCViewerView::OnFlipv() 
{
	int fs=ActiveImage->FlipState;
	fs^= 2;
	ActiveImage->FlipState=(doFlipState)fs;
}

void CMSVCViewerView::OnLeveldown() 
{
	ActiveImage->Level-=ActiveImage->Width/10;
}

void CMSVCViewerView::OnLevelup() 
{
	ActiveImage->Level+=ActiveImage->Width/10;
}

void CMSVCViewerView::OnRotate() 
{
	int rs=ActiveImage->RotateState;
	rs=(rs+3) % 4;
	ActiveImage->RotateState=(doRotateState)rs;
}

void CMSVCViewerView::OnWindowwide() 
{	
	ActiveImage->Width=ActiveImage->Width*1.2;
}

void CMSVCViewerView::OnWindownarrow() 
{
	ActiveImage->Width=ActiveImage->Width/1.2;
}

void CMSVCViewerView::OnDestroy() 
{
	AfxConnectionUnadvise(m_viewer.GetControlUnknown(),IID_IDicomViewerSink,pSink->GetIDispatch(false),true,SinkCookie);
	delete pSink;
	CView::OnDestroy();	
}

void CMSVCViewerView::OnZoomin() 
{
	ActiveImage->Zoom*=1.2F;
}

void CMSVCViewerView::OnZoomout() 
{
	ActiveImage->Zoom/=1.2F;
}

void CMSVCViewerView::OnUpdateZoomin(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!(ActiveImage->StretchMode==StretchCentred));
}

void CMSVCViewerView::OnUpdateZoomout(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!(ActiveImage->StretchMode==StretchCentred));
}

void CMSVCViewerView::OnStretchtofit() 
{
	ActiveImage->StretchMode=(doStretchModes)~(ActiveImage->StretchMode);
}

void CMSVCViewerView::OnUpdateStretchtofit(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck((ActiveImage->StretchMode==StretchCentred)?1:0);
}

void CMSVCViewerView::OnFileApplypresentationstate() 
{
	CFileDialog d(true,NULL,NULL,0,_T("Presentation States (*.pre)|*.pre|All Files|*.*||"),this);;
	int result=d.DoModal();
	if(result==IDOK)
	{
		IDicomDataSetsPtr ds;
		ds.CreateInstance("DicomObjects8.DicomDataSets");
		ActiveImage->PresentationState=ds->ReadFile(_bstr_t(d.GetPathName()));
	}
}

BOOL CMSVCViewerView::OnPreparePrinting(CPrintInfo* pInfo) 
{
	return DoPreparePrinting(pInfo);
}

void CMSVCViewerView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
    long w, h, w1, h1 ;
    IPicturePtr picture=ActiveImage->Picture();
	picture->get_Width(&w1);
	picture->get_Height(&h1);
    w = pInfo->m_rectDraw.Width() - 400;
    h = w * h1 / w1;
	picture->Render(pDC->m_hDC,200,200,w, h, 0, h1, w1,-h1,pInfo->m_rectDraw);
}

void CMSVCViewerView::OnFileExport() 
{
	CFileDialog d(false,NULL,NULL,0,_T("Images (*.JPG, *.BMP, *.DIB)|*.JPG;*.BMP;*.DIB||"),this);;
	int result=d.DoModal();
	if(result==IDOK)
	{
		ActiveImage->FileExport(_bstr_t(d.GetPathName()),_bstr_t(""));
	}
	
}

void CMSVCViewerView::OnRemoteSendselected() 
{
	int status=ActiveImage->Send(_bstr_t(pOptions->m_RemoteIP),pOptions->m_RemotePort,
							_bstr_t(pOptions->m_LocalAET),
							_bstr_t(pOptions->m_RemoteAET));
	if(status==0)
		AfxMessageBox("Send OK");
	else
	{
		CString m;
		m.Format("Send failed - status = 0x%x",status);
		AfxMessageBox(m);
	}	
}

void CMSVCViewerView::OnCineRuncine() 
{
	ActiveImage->CineMode=doCineRepeat;	
}

void CMSVCViewerView::OnCineReverse() 
{
	ActiveImage->CineMode=doCineReverse;	
}

void CMSVCViewerView::OnCineOscillate() 
{
	ActiveImage->CineMode=doCineOscillate;	
}

void CMSVCViewerView::OnCineStop() 
{
	ActiveImage->CineMode=doCineStatic;	
}

void CMSVCViewerView::OnFilePrintdicom() 
{
    CPrintOptions * pPrintOptions=&(((CMSVCViewerApp*)AfxGetApp())->printOptions);;
	IDicomPrintPtr printer("DicomObjects8.DicomPrint");
	IDicomImagePtr Image;
    
    printer->Node = _bstr_t(pPrintOptions->m_PrinterIP);
    printer->Port = pPrintOptions->m_PrinterPort;
    printer->CalledAE = _bstr_t(pPrintOptions->m_PrinterAET);
    printer->CallingAE = _bstr_t(pPrintOptions->m_localAET);
    printer->Open();
    
    printer->Format = "STANDARD\\1,1";
    printer->Orientation = "PORTRAIT";
    printer->FilmSize = "17INx14IN";
    
	printer->PrintImage(ActiveImage,false,true);
    
    printer->Close();
	
}
